/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleWrapped2DTransformAs3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.Wrapped2DTransformAs3D;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.persist.IClassAdapter;

@Plugin(type=IClassAdapter.class)
public class Wrapped2DTransformAs3DRealTransformAdapter
implements IClassAdapter<Wrapped2DTransformAs3D> {
    protected static final Logger logger = LoggerFactory.getLogger(Wrapped2DTransformAs3DRealTransformAdapter.class);

    public Wrapped2DTransformAs3D deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject obj = jsonElement.getAsJsonObject();
        RealTransform rt = (RealTransform)jsonDeserializationContext.deserialize(obj.get("wrappedTransform"), RealTransform.class);
        if (!(rt instanceof InvertibleRealTransform)) {
            return new Wrapped2DTransformAs3D(rt);
        }
        return new InvertibleWrapped2DTransformAs3D((InvertibleRealTransform)rt);
    }

    public JsonElement serialize(Wrapped2DTransformAs3D wrapped2DTransformAs3D, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        obj.add("wrappedTransform", jsonSerializationContext.serialize((Object)wrapped2DTransformAs3D.getTransform(), RealTransform.class));
        return obj;
    }

    @Override
    public Class<? extends Wrapped2DTransformAs3D> getAdapterClass() {
        return Wrapped2DTransformAs3D.class;
    }
}

