/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import net.imglib2.realtransform.ThinplateSplineTransform;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.persist.IClassAdapter;

@Plugin(type=IClassAdapter.class)
public class ThinPlateSplineTransformAdapter
implements IClassAdapter<ThinplateSplineTransform> {
    protected static final Logger logger = LoggerFactory.getLogger(ThinPlateSplineTransformAdapter.class);

    public ThinplateSplineTransform deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = jsonElement.getAsJsonObject();
        double[][] srcPts = (double[][])context.deserialize(obj.get("srcPts"), double[][].class);
        double[][] tgtPts = (double[][])context.deserialize(obj.get("tgtPts"), double[][].class);
        return new ThinplateSplineTransform(srcPts, tgtPts);
    }

    public JsonElement serialize(ThinplateSplineTransform thinplateSplineTransform, Type type, JsonSerializationContext jsonSerializationContext) {
        ThinPlateR2LogRSplineKernelTransform kernel = ThinPlateSplineTransformAdapter.getKernel(thinplateSplineTransform);
        assert (kernel != null);
        double[][] srcPts = ThinPlateSplineTransformAdapter.getSrcPts(kernel);
        double[][] tgtPts = ThinPlateSplineTransformAdapter.getTgtPts(kernel);
        JsonObject obj = new JsonObject();
        obj.add("srcPts", jsonSerializationContext.serialize((Object)srcPts));
        obj.add("tgtPts", jsonSerializationContext.serialize((Object)tgtPts));
        return obj;
    }

    public static ThinPlateR2LogRSplineKernelTransform getKernel(ThinplateSplineTransform thinplateSplineTransform) {
        try {
            Field kernelField = ThinplateSplineTransform.class.getDeclaredField("tps");
            kernelField.setAccessible(true);
            return (ThinPlateR2LogRSplineKernelTransform)kernelField.get(thinplateSplineTransform);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Could not get kernel from ThinPlateSplineTransform");
            return null;
        }
    }

    public static double[][] getSrcPts(ThinPlateR2LogRSplineKernelTransform kernel) {
        return kernel.getSourceLandmarks();
    }

    public static double[][] getTgtPts(ThinPlateR2LogRSplineKernelTransform kernel) {
        double[][] srcPts = kernel.getSourceLandmarks();
        int nbLandmarks = kernel.getNumLandmarks();
        int nbDimensions = kernel.getNumDims();
        double[][] tgtPts = new double[nbDimensions][nbLandmarks];
        for (int i = 0; i < nbLandmarks; ++i) {
            double[] srcPt = new double[nbDimensions];
            for (int d = 0; d < nbDimensions; ++d) {
                srcPt[d] = srcPts[d][i];
            }
            double[] tgtPt = kernel.apply(srcPt);
            for (int d = 0; d < nbDimensions; ++d) {
                tgtPts[d][i] = tgtPt[d];
            }
        }
        return tgtPts;
    }

    @Override
    public Class<? extends ThinplateSplineTransform> getAdapterClass() {
        return ThinplateSplineTransform.class;
    }
}

