/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import org.scijava.plugin.Plugin;
import sc.fiji.persist.IClassAdapter;

@Plugin(type=IClassAdapter.class)
public class RealTransformSequenceAdapter
implements IClassAdapter<RealTransformSequence> {
    @Override
    public Class<? extends RealTransformSequence> getAdapterClass() {
        return RealTransformSequence.class;
    }

    public RealTransformSequence deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        JsonObject obj = jsonElement.getAsJsonObject();
        int nTransform = obj.get("size").getAsInt();
        RealTransformSequence rts = new RealTransformSequence();
        for (int iTransform = 0; iTransform < nTransform; ++iTransform) {
            RealTransform transform = (RealTransform)jsonDeserializationContext.deserialize(obj.get("realTransform_" + iTransform), RealTransform.class);
            rts.add(transform);
        }
        return rts;
    }

    public JsonElement serialize(RealTransformSequence rts, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        obj.addProperty("size", (Number)rts.transforms.size());
        for (int iTransform = 0; iTransform < rts.transforms.size(); ++iTransform) {
            obj.add("realTransform_" + iTransform, jsonSerializationContext.serialize(rts.transforms.get(iTransform), RealTransform.class));
        }
        return obj;
    }
}

