/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleRealTransformSequence;
import net.imglib2.realtransform.RealTransform;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.persist.IClassAdapter;

@Plugin(type=IClassAdapter.class)
public class InvertibleRealTransformSequenceAdapter
implements IClassAdapter<InvertibleRealTransformSequence> {
    protected static final Logger logger = LoggerFactory.getLogger(InvertibleRealTransformSequenceAdapter.class);

    @Override
    public Class<? extends InvertibleRealTransformSequence> getAdapterClass() {
        return InvertibleRealTransformSequence.class;
    }

    public InvertibleRealTransformSequence deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject obj = jsonElement.getAsJsonObject();
        int nTransform = obj.get("size").getAsInt();
        InvertibleRealTransformSequence irts = new InvertibleRealTransformSequence();
        for (int iTransform = 0; iTransform < nTransform; ++iTransform) {
            JsonObject jsonObj = obj.get("realTransform_" + iTransform).getAsJsonObject();
            if (jsonObj.has("affinetransform3d")) {
                AffineTransform3D at3D = (AffineTransform3D)jsonDeserializationContext.deserialize(obj.get("realTransform_" + iTransform), AffineTransform3D.class);
                irts.add((RealTransform)at3D);
                continue;
            }
            RealTransform transform = (RealTransform)jsonDeserializationContext.deserialize(obj.get("realTransform_" + iTransform), RealTransform.class);
            if (transform instanceof InvertibleRealTransform) {
                irts.add((RealTransform)((InvertibleRealTransform)transform));
                continue;
            }
            logger.error("Deserialization error: " + transform + " of class " + transform.getClass().getSimpleName() + " is not invertible!");
            return null;
        }
        return irts;
    }

    public JsonElement serialize(InvertibleRealTransformSequence irts, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        obj.addProperty("size", (Number)irts.transforms.size());
        for (int iTransform = 0; iTransform < irts.transforms.size(); ++iTransform) {
            obj.add("realTransform_" + iTransform, jsonSerializationContext.serialize(irts.transforms.get(iTransform), RealTransform.class));
        }
        return obj;
    }
}

