/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.cache.SharedQueue;
import bdv.util.DefaultInterpolators;
import bdv.util.volatiles.VolatileViews;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import java.util.concurrent.ConcurrentHashMap;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.Volatile;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.type.operators.SetZero;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.type.volatiles.VolatileFloatType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;
import net.imglib2.type.volatiles.VolatileUnsignedIntType;
import net.imglib2.type.volatiles.VolatileUnsignedShortType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public class WrapVolatileSource<T extends NumericType<T>, V extends Volatile<T>>
implements Source<V> {
    final Source<T> originSource;
    Source<V> volatileSource = null;
    protected final DefaultInterpolators<V> interpolators = new DefaultInterpolators();
    final SharedQueue queue;
    final ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, RandomAccessibleInterval<V>>> cachedRAIs = new ConcurrentHashMap();

    public WrapVolatileSource(Source<T> source) {
        this.originSource = source;
        this.queue = new SharedQueue(2);
    }

    public WrapVolatileSource(Source<T> originSource, SharedQueue queue) {
        this.originSource = originSource;
        this.volatileSource = null;
        this.queue = queue;
    }

    public void setVolatileSourceForHighestResolution(Source<V> volatileSource) {
        this.volatileSource = volatileSource;
    }

    @Override
    public boolean isPresent(int t) {
        return this.originSource.isPresent(t);
    }

    public RandomAccessibleInterval<V> buildSource(int t, int level) {
        if (level == 0 && this.volatileSource != null) {
            return this.volatileSource.getSource(t, 0);
        }
        return VolatileViews.wrapAsVolatile(this.originSource.getSource(t, level), (SharedQueue)this.queue);
    }

    @Override
    public RandomAccessibleInterval<V> getSource(int t, int level) {
        if (!this.cachedRAIs.containsKey(t)) {
            this.cachedRAIs.put(t, new ConcurrentHashMap());
        }
        if (!this.cachedRAIs.get(t).containsKey(level)) {
            RandomAccessibleInterval<V> nonCached = this.buildSource(t, level);
            this.cachedRAIs.get(t).put(level, nonCached);
        }
        return this.cachedRAIs.get(t).get(level);
    }

    @Override
    public RealRandomAccessible<V> getInterpolatedSource(int t, int level, Interpolation method) {
        V zero = this.getType();
        ((SetZero)zero).setZero();
        ExtendedRandomAccessibleInterval eView = Views.extendZero(this.getSource(t, level));
        RealRandomAccessible realRandomAccessible = Views.interpolate((EuclideanSpace)eView, (InterpolatorFactory)this.interpolators.get(method));
        return realRandomAccessible;
    }

    @Override
    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        this.originSource.getSourceTransform(t, level, transform);
    }

    @Override
    public V getType() {
        return WrapVolatileSource.getVolatileOf((NumericType)this.originSource.getType());
    }

    @Override
    public String getName() {
        return this.originSource.getName();
    }

    @Override
    public VoxelDimensions getVoxelDimensions() {
        return this.originSource.getVoxelDimensions();
    }

    @Override
    public int getNumMipmapLevels() {
        return this.originSource.getNumMipmapLevels();
    }

    public static <T extends NumericType<T>, V extends Volatile<T>> V getVolatileOf(NumericType<T> t) {
        if (t instanceof UnsignedShortType) {
            return (V)new VolatileUnsignedShortType();
        }
        if (t instanceof UnsignedIntType) {
            return (V)new VolatileUnsignedIntType();
        }
        if (t instanceof UnsignedByteType) {
            return (V)new VolatileUnsignedByteType();
        }
        if (t instanceof FloatType) {
            return (V)new VolatileFloatType();
        }
        if (t instanceof ARGBType) {
            return (V)new VolatileARGBType();
        }
        throw new RuntimeException("Unknown volatile type matching pixel type " + t.getClass().getName());
    }
}

