/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceToUnsignedShortConverter {
    protected static final Logger logger = LoggerFactory.getLogger(SourceToUnsignedShortConverter.class);

    public static Source<UnsignedShortType> convertRealSource(final Source<RealType> iniSrc) {
        final Converter cvt = (i, o) -> o.set((int)i.getRealDouble());
        Source<UnsignedShortType> cvtSrc = new Source<UnsignedShortType>(){

            @Override
            public boolean isPresent(int t) {
                return iniSrc.isPresent(t);
            }

            @Override
            public RandomAccessibleInterval<UnsignedShortType> getSource(int t, int level) {
                return Converters.convert(iniSrc.getSource(t, level), (Converter)cvt, (Type)new UnsignedShortType());
            }

            @Override
            public RealRandomAccessible<UnsignedShortType> getInterpolatedSource(int t, int level, Interpolation method) {
                return Converters.convert(iniSrc.getInterpolatedSource(t, level, method), (Converter)cvt, (Type)new UnsignedShortType());
            }

            @Override
            public void getSourceTransform(int t, int level, AffineTransform3D transform) {
                iniSrc.getSourceTransform(t, level, transform);
            }

            @Override
            public UnsignedShortType getType() {
                return new UnsignedShortType();
            }

            @Override
            public String getName() {
                return iniSrc.getName();
            }

            @Override
            public VoxelDimensions getVoxelDimensions() {
                return iniSrc.getVoxelDimensions();
            }

            @Override
            public int getNumMipmapLevels() {
                return iniSrc.getNumMipmapLevels();
            }
        };
        return cvtSrc;
    }

    public static <T> Source<UnsignedShortType> convertSource(Source<T> iniSrc) {
        if (iniSrc.getType() instanceof UnsignedShortType) {
            return iniSrc;
        }
        if (iniSrc.getType() instanceof RealType) {
            return SourceToUnsignedShortConverter.convertRealSource(iniSrc);
        }
        logger.error("Cannot convert source to Unsigned Short Type, " + iniSrc.getType().getClass().getSimpleName() + " cannot be converted to RealType");
        return null;
    }
}

