/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.img.WarpedSource;
import bdv.tools.transformation.TransformedSource;
import bdv.util.DefaultInterpolators;
import bdv.util.RAIHelper;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class ResampledSource<T extends NumericType<T> & NativeType<T>>
implements Source<T> {
    protected static final Logger logger = LoggerFactory.getLogger(ResampledSource.class);
    final transient ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, RandomAccessibleInterval<T>>> cachedRAIs = new ConcurrentHashMap();
    final Source<T> origin;
    final Source<?> resamplingModel;
    protected final DefaultInterpolators<T> interpolators = new DefaultInterpolators();
    protected final Interpolation originInterpolation;
    final boolean reuseMipMaps;
    final int defaultMipMapLevel;
    final boolean cache;
    private final String name;
    final Map<Integer, Integer> mipmapModelToOrigin = new HashMap<Integer, Integer>();
    List<Double> originVoxSize;

    public ResampledSource(Source<T> source, Source<?> resamplingModel, String name, boolean reuseMipMaps, boolean cache, boolean originInterpolation, int defaultMipMapLevel) {
        this.origin = source;
        this.resamplingModel = resamplingModel;
        this.name = name;
        this.reuseMipMaps = reuseMipMaps;
        this.cache = cache;
        this.originInterpolation = originInterpolation ? Interpolation.NLINEAR : Interpolation.NEARESTNEIGHBOR;
        this.defaultMipMapLevel = defaultMipMapLevel;
        this.computeMipMapsCorrespondance();
    }

    private int bestMatch(double voxSize) {
        int level;
        if (this.originVoxSize == null) {
            this.computeOriginSize();
        }
        for (level = 0; this.originVoxSize.get(level) < voxSize && level < this.originVoxSize.size() - 1; ++level) {
        }
        return level;
    }

    private void computeOriginSize() {
        this.originVoxSize = new ArrayList<Double>();
        Source rootOrigin = this.origin;
        while (rootOrigin instanceof WarpedSource || rootOrigin instanceof TransformedSource) {
            if (rootOrigin instanceof WarpedSource) {
                rootOrigin = ((WarpedSource)rootOrigin).getWrappedSource();
                continue;
            }
            rootOrigin = ((TransformedSource)rootOrigin).getWrappedSource();
        }
        for (int l = 0; l < rootOrigin.getNumMipmapLevels(); ++l) {
            AffineTransform3D at3d = new AffineTransform3D();
            rootOrigin.getSourceTransform(0, l, at3d);
            double mid = SourceAndConverterHelper.getCharacteristicVoxelSize(at3d);
            this.originVoxSize.add(mid);
        }
    }

    private void computeMipMapsCorrespondance() {
        AffineTransform3D at3D = new AffineTransform3D();
        for (int l = 0; l < this.resamplingModel.getNumMipmapLevels(); ++l) {
            if (this.reuseMipMaps) {
                this.resamplingModel.getSourceTransform(0, l, at3D);
                double middleDim = SourceAndConverterHelper.getCharacteristicVoxelSize(at3D);
                int match = this.bestMatch(middleDim);
                this.mipmapModelToOrigin.put(l, match);
            } else {
                this.mipmapModelToOrigin.put(l, this.defaultMipMapLevel);
            }
            logger.debug("Model mipmap level " + l + " correspond to origin mipmap level " + this.mipmapModelToOrigin.get(l));
            logger.debug("Model mipmap level " + l + " has a characteristic voxel size of " + SourceAndConverterHelper.getCharacteristicVoxelSize(this.resamplingModel, 0, l));
            logger.debug("Origin level " + this.mipmapModelToOrigin.get(l) + " has a characteristic voxel size of " + SourceAndConverterHelper.getCharacteristicVoxelSize(this.origin, 0, (int)this.mipmapModelToOrigin.get(l)));
        }
    }

    public int getModelToOriginMipMapLevel(int mipmapModel) {
        return this.mipmapModelToOrigin.get(mipmapModel);
    }

    public Source<?> getOriginalSource() {
        return this.origin;
    }

    public Source<?> getModelResamplerSource() {
        return this.resamplingModel;
    }

    @Override
    public boolean isPresent(int t) {
        return this.origin.isPresent(t) && this.resamplingModel.isPresent(t);
    }

    public boolean areMipmapsReused() {
        return this.reuseMipMaps;
    }

    public boolean isCached() {
        return this.cache;
    }

    public Interpolation originInterpolation() {
        return this.originInterpolation;
    }

    @Override
    public RandomAccessibleInterval<T> getSource(int t, int level) {
        if (this.cache) {
            if (!this.cachedRAIs.containsKey(t)) {
                this.cachedRAIs.put(t, new ConcurrentHashMap());
            }
            if (!this.cachedRAIs.get(t).containsKey(level)) {
                RandomAccessibleInterval<T> nonCached = this.buildSource(t, level);
                int[] blockSize = new int[]{64, 64, 64};
                if (nonCached.dimension(0) < 64L) {
                    blockSize[0] = (int)nonCached.dimension(0);
                }
                if (nonCached.dimension(1) < 64L) {
                    blockSize[1] = (int)nonCached.dimension(1);
                }
                if (nonCached.dimension(2) < 64L) {
                    blockSize[2] = (int)nonCached.dimension(2);
                }
                this.cachedRAIs.get(t).put(level, RAIHelper.wrapAsVolatileCachedCellImg(nonCached, blockSize, this, t, level, (NativeType)this.getType()));
            }
            return this.cachedRAIs.get(t).get(level);
        }
        return this.buildSource(t, level);
    }

    public RandomAccessibleInterval<T> buildSource(int t, int level) {
        AffineTransform3D at = new AffineTransform3D();
        this.resamplingModel.getSourceTransform(t, level, at);
        long sx = this.resamplingModel.getSource(t, level).dimension(0) - 1L;
        long sy = this.resamplingModel.getSource(t, level).dimension(1) - 1L;
        long sz = this.resamplingModel.getSource(t, level).dimension(2) - 1L;
        RealRandomAccessible<T> ipimg = this.origin.getInterpolatedSource(t, this.getModelToOriginMipMapLevel(level), this.originInterpolation);
        at = at.inverse();
        AffineTransform3D atOrigin = new AffineTransform3D();
        this.origin.getSourceTransform(t, this.getModelToOriginMipMapLevel(level), atOrigin);
        at.concatenate(atOrigin);
        RandomAccessible ra = RealViews.simplify((RealRandomAccessible)RealViews.affine(ipimg, (AffineGet)at));
        IntervalView view = Views.interval((RandomAccessible)ra, (long[])new long[]{0L, 0L, 0L}, (long[])new long[]{sx, sy, sz});
        return view;
    }

    @Override
    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        T zero = this.getType();
        zero.setZero();
        ExtendedRandomAccessibleInterval eView = Views.extendZero(this.getSource(t, level));
        RealRandomAccessible realRandomAccessible = Views.interpolate((EuclideanSpace)eView, (InterpolatorFactory)this.interpolators.get(method));
        return realRandomAccessible;
    }

    @Override
    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        this.resamplingModel.getSourceTransform(t, level, transform);
    }

    @Override
    public T getType() {
        return (T)((NumericType)((NumericType)this.origin.getType()).createVariable());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VoxelDimensions getVoxelDimensions() {
        return this.resamplingModel.getVoxelDimensions();
    }

    @Override
    public int getNumMipmapLevels() {
        return this.resamplingModel.getNumMipmapLevels();
    }

    public int getDefaultMipMapLevel() {
        return this.defaultMipMapLevel;
    }
}

