/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import java.util.Set;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.lazy.Caches;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.LoadedCellCacheLoader;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.type.numeric.integer.GenericLongType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import sc.fiji.bdvpg.cache.GlobalLoaderCache;

public class RAIHelper {
    public static <T extends NativeType<T>> RandomAccessibleInterval<T> wrapAsVolatileCachedCellImg(RandomAccessibleInterval<T> source, int[] blockSize, Object objectSource, int timepoint, int level, T type) {
        CachedCellImg img;
        long[] dimensions = Intervals.dimensionsAsLongArray(source);
        CellGrid grid = new CellGrid(dimensions, blockSize);
        Caches.RandomAccessibleLoader loader = new Caches.RandomAccessibleLoader((RandomAccessible)Views.zeroMin(source));
        Cache cache = new GlobalLoaderCache(objectSource, timepoint, level).withLoader((CacheLoader)LoadedCellCacheLoader.get((CellGrid)grid, (CellLoader)loader, type, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        if (GenericByteType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.BYTE, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else if (GenericShortType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.SHORT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else if (GenericIntType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.INT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else if (GenericLongType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.LONG, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else if (FloatType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.FLOAT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else if (DoubleType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.DOUBLE, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else if (ARGBType.class.isInstance(type)) {
            img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.INT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
        } else {
            throw new UnsupportedOperationException("Cannot resample RAI (wrapAsVolatileCachedCellImg) of pixel type " + type.getClass().getName());
        }
        return img;
    }
}

