/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.tools.brightness.ConverterSetup;
import java.util.Arrays;
import java.util.List;
import net.imglib2.converter.RealLUTConverter;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import org.scijava.listeners.Listeners;

public class LUTConverterSetup<R extends RealType<R>>
implements ConverterSetup {
    protected final List<RealLUTConverter<R>> converters;
    private final Listeners.List<ConverterSetup.SetupChangeListener> listeners = new Listeners.SynchronizedList();

    @SafeVarargs
    public LUTConverterSetup(RealLUTConverter<R> ... converters) {
        this(Arrays.asList(converters));
    }

    public LUTConverterSetup(List<RealLUTConverter<R>> converters) {
        this.converters = converters;
    }

    @Override
    public void setDisplayRange(double min, double max) {
        for (RealLUTConverter<R> converter : this.converters) {
            converter.setMin(min);
            converter.setMax(max);
        }
        this.listeners.list.forEach(scl -> scl.setupParametersChanged(this));
    }

    @Override
    public void setColor(ARGBType color) {
    }

    @Override
    public boolean supportsColor() {
        return false;
    }

    @Override
    public Listeners<ConverterSetup.SetupChangeListener> setupChangeListeners() {
        return this.listeners;
    }

    @Override
    public int getSetupId() {
        return 0;
    }

    @Override
    public double getDisplayRangeMin() {
        return this.converters.get(0).getMin();
    }

    @Override
    public double getDisplayRangeMax() {
        return this.converters.get(0).getMax();
    }

    @Override
    public ARGBType getColor() {
        return null;
    }
}

