/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.DefaultInterpolators;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import java.io.Serializable;
import java.util.function.BiConsumer;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.position.FunctionRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public class EmptySource
implements Source<UnsignedShortType>,
Serializable {
    final transient RandomAccessibleInterval<UnsignedShortType> rai;
    final EmptySourceParams params;
    protected final transient DefaultInterpolators<UnsignedShortType> interpolators = new DefaultInterpolators();

    public EmptySourceParams getParameters() {
        return new EmptySourceParams(this.params);
    }

    public EmptySource(EmptySourceParams p) {
        this(p.nx, p.ny, p.nz, p.at3D, p.name, p.voxelDimensions);
    }

    public EmptySource(long nx, long ny, long nz, AffineTransform3D at3D, String name, VoxelDimensions voxelDimensions) {
        this.params = new EmptySourceParams();
        this.params.nx = nx;
        this.params.ny = ny;
        this.params.nz = nz;
        this.params.voxelDimensions = voxelDimensions;
        BiConsumer<Localizable, UnsignedShortType> fun = (l, t) -> t.set(0);
        FunctionRandomAccessible ra = new FunctionRandomAccessible(3, fun, UnsignedShortType::new);
        this.rai = Views.interval((RandomAccessible)ra, (Interval)new FinalInterval(new long[]{nx, ny, nz}));
        this.params.at3D = at3D;
        this.params.name = name;
    }

    @Override
    public boolean isPresent(int t) {
        return true;
    }

    @Override
    public RandomAccessibleInterval<UnsignedShortType> getSource(int t, int level) {
        return this.rai;
    }

    @Override
    public RealRandomAccessible<UnsignedShortType> getInterpolatedSource(int t, int level, Interpolation method) {
        ExtendedRandomAccessibleInterval eView = Views.extendZero(this.getSource(t, level));
        return Views.interpolate((EuclideanSpace)eView, (InterpolatorFactory)this.interpolators.get(method));
    }

    @Override
    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.set(this.params.at3D);
    }

    @Override
    public UnsignedShortType getType() {
        return new UnsignedShortType();
    }

    @Override
    public String getName() {
        return this.params.name;
    }

    @Override
    public VoxelDimensions getVoxelDimensions() {
        return this.params.voxelDimensions;
    }

    @Override
    public int getNumMipmapLevels() {
        return 1;
    }

    public static class EmptySourceParams
    implements Serializable {
        public long nx;
        public long ny;
        public long nz;
        public AffineTransform3D at3D;
        public String name;
        transient VoxelDimensions voxelDimensions;
        public String unit = "pixel";
        public double vx = 1.0;
        public double vy = 1.0;
        public double vz = 1.0;

        public EmptySourceParams() {
            this.nx = 1L;
            this.ny = 1L;
            this.nz = 1L;
            this.at3D = new AffineTransform3D();
            this.name = "";
            this.voxelDimensions = new FinalVoxelDimensions(this.unit, new double[]{this.vx, this.vy, this.vz});
        }

        public void setVoxelDimensions(String unit, double vx, double vy, double vz) {
            this.unit = unit;
            this.vx = vx;
            this.vy = vy;
            this.vz = vz;
            this.voxelDimensions = new FinalVoxelDimensions(unit, new double[]{vx, vy, vz});
        }

        public EmptySourceParams(EmptySourceParams p) {
            this.nx = p.nx;
            this.ny = p.ny;
            this.nz = p.nz;
            this.vx = p.vx;
            this.vy = p.vy;
            this.vz = p.vz;
            this.unit = p.unit;
            this.at3D = new AffineTransform3D();
            this.at3D.set(p.at3D);
            this.name = p.name;
            this.voxelDimensions = p.voxelDimensions;
            this.vx = p.vx;
            this.vy = p.vy;
            this.vz = p.vz;
            this.unit = p.unit;
        }
    }
}

