/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.imglib2.RealPoint;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.ThinplateSplineTransform;
import net.imglib2.realtransform.Wrapped2DTransformAs3D;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;

public class BigWarpHelper {
    public static RealTransform realTransformFromBigWarpFile(File f, boolean force3d) throws Exception {
        CSVReader reader = new CSVReader((Reader)new FileReader(f.getAbsolutePath()));
        List rows = reader.readAll();
        reader.close();
        if (rows == null || rows.size() < 1) {
            throw new IOException("Wrong number of rows in file " + f.getAbsolutePath());
        }
        int ndims = 3;
        int expectedRowLength = 8;
        int numRowsTmp = 0;
        ArrayList<double[]> movingPts = new ArrayList<double[]>();
        ArrayList<double[]> targetPts = new ArrayList<double[]>();
        for (String[] row : rows) {
            int d;
            if (numRowsTmp == 0 && row.length == 6) {
                ndims = 2;
                expectedRowLength = 6;
            }
            if (row.length != expectedRowLength) {
                throw new IOException("Invalid file - not enough columns");
            }
            double[] movingPt = new double[ndims];
            double[] targetPt = new double[ndims];
            int k = 2;
            for (d = 0; d < ndims; ++d) {
                movingPt[d] = Double.parseDouble(row[k++]);
            }
            for (d = 0; d < ndims; ++d) {
                targetPt[d] = Double.parseDouble(row[k++]);
            }
            movingPts.add(movingPt);
            targetPts.add(targetPt);
            ++numRowsTmp;
        }
        ArrayList<RealPoint> moving_pts = new ArrayList<RealPoint>();
        ArrayList<RealPoint> fixed_pts = new ArrayList<RealPoint>();
        for (int indexLandmark = 0; indexLandmark < numRowsTmp; ++indexLandmark) {
            RealPoint moving = new RealPoint(ndims);
            RealPoint fixed = new RealPoint(ndims);
            moving.setPosition((double[])movingPts.get(indexLandmark));
            fixed.setPosition((double[])targetPts.get(indexLandmark));
            moving_pts.add(moving);
            fixed_pts.add(fixed);
        }
        ThinplateSplineTransform tst = BigWarpHelper.getTransform(moving_pts, fixed_pts, false);
        WrappedIterativeInvertibleRealTransform irt = new WrappedIterativeInvertibleRealTransform((RealTransform)tst);
        if (force3d && irt.numSourceDimensions() == 2) {
            return new Wrapped2DTransformAs3D((RealTransform)irt);
        }
        return irt;
    }

    public static ThinplateSplineTransform getTransform(List<RealPoint> moving_pts, List<RealPoint> fixed_pts, boolean force2d) {
        int nbDimensions = moving_pts.get(0).numDimensions();
        int nbLandmarks = moving_pts.size();
        if (force2d) {
            nbDimensions = 2;
        }
        double[][] mPts = new double[nbDimensions][nbLandmarks];
        double[][] fPts = new double[nbDimensions][nbLandmarks];
        for (int i = 0; i < nbLandmarks; ++i) {
            int d;
            for (d = 0; d < nbDimensions; ++d) {
                fPts[d][i] = fixed_pts.get(i).getDoublePosition(d);
            }
            for (d = 0; d < nbDimensions; ++d) {
                mPts[d][i] = moving_pts.get(i).getDoublePosition(d);
            }
        }
        return new ThinplateSplineTransform(fPts, mPts);
    }
}

