/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import loci.formats.CoreMetadata;
import loci.formats.MetadataList;

public class CoreMetadataList
extends MetadataList<CoreMetadata> {
    static final Comparator<CoreMetadata> comparator = new Comparator<CoreMetadata>(){

        @Override
        public int compare(CoreMetadata c1, CoreMetadata c2) {
            int result = Integer.compare(c1.sizeZ, c2.sizeZ);
            if (result == 0) {
                result = Integer.compare(c1.sizeY, c2.sizeY);
            }
            if (result == 0) {
                result = Integer.compare(c1.sizeX, c2.sizeX);
            }
            return -result;
        }
    };

    public CoreMetadataList() {
    }

    public CoreMetadataList(CoreMetadataList copy) {
        super(copy);
    }

    public CoreMetadataList(int size1) {
        super(size1);
    }

    public CoreMetadataList(int size1, int size2) {
        super(size1, size2);
    }

    public CoreMetadataList(int[] sizes) {
        super(sizes);
    }

    public CoreMetadataList(List<CoreMetadata> list) {
        this.setFlattenedList(list);
    }

    @Override
    public void add(int i1, CoreMetadata value) {
        super.add(i1, value);
    }

    public void reorder() {
        for (List s : this.data) {
            Collections.sort(s, comparator);
        }
    }

    public List<CoreMetadata> getFlattenedList() {
        ArrayList<CoreMetadata> l = new ArrayList<CoreMetadata>();
        int[] sizes = this.sizes();
        for (int i = 0; i < sizes.length; ++i) {
            if (sizes[i] > 0) {
                ((CoreMetadata)this.get((int)i, (int)0)).resolutionCount = sizes[i];
            }
            for (int j = 0; j < sizes[i]; ++j) {
                l.add(new CoreMetadata((CoreMetadata)this.get(i, j)));
            }
        }
        return l;
    }

    public void setFlattenedList(List<CoreMetadata> list) {
        this.clear();
        for (int i = 0; i < list.size(); i += list.get((int)i).resolutionCount) {
            ArrayList<CoreMetadata> sublist = new ArrayList<CoreMetadata>();
            for (int j = 0; j < list.get((int)i).resolutionCount; ++j) {
                sublist.add(list.get(i + j));
            }
            this.add(sublist);
        }
    }

    public List<CoreMetadata> getSeriesList() {
        ArrayList<CoreMetadata> l = new ArrayList<CoreMetadata>();
        for (int i = 0; i < this.size(); ++i) {
            l.add(new CoreMetadata((CoreMetadata)this.get(i, 0)));
        }
        for (CoreMetadata c : l) {
            c.resolutionCount = 1;
        }
        return l;
    }

    public int flattenedSize() {
        int ncore = 0;
        for (int v : this.sizes()) {
            ncore += v;
        }
        return ncore;
    }

    public int flattenedIndex(int series, int resolution) {
        int idx = 0;
        if (series < 0 || series >= this.size()) {
            throw new IllegalArgumentException("Invalid series: " + series);
        }
        for (int i = 0; i < series; ++i) {
            idx += this.size(i);
        }
        if (resolution < 0 || resolution >= this.size(series)) {
            throw new IllegalArgumentException("Invalid resolution: " + resolution);
        }
        return idx += resolution;
    }

    public int[] flattenedIndexes(int flattenedIndex) {
        int series = 0;
        int resolution = 0;
        if (flattenedIndex >= this.flattenedSize()) {
            throw new IllegalArgumentException("Invalid flattened index: " + flattenedIndex);
        }
        int found = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.size(i) <= flattenedIndex - found) {
                ++series;
                if ((found += this.size(i)) != flattenedIndex) continue;
                break;
            }
            resolution = flattenedIndex - found;
            break;
        }
        return new int[]{series, resolution};
    }
}

