/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bdv.BigDataViewer;
import bdv.export.ProgressWriter;
import bdv.ij.util.ProgressWriterIJ;
import bdv.viewer.ViewerOptions;
import ij.Prefs;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer>Open XML/HDF5")
public class BigDataViewerPlugIn
implements Command {
    static String lastDatasetPath = "./export.xml";

    public void run() {
        if (Prefs.setIJMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        File file = null;
        if (Prefs.useJFileChooser) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setSelectedFile(new File(lastDatasetPath));
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "xml files";
                }

                @Override
                public boolean accept(File f) {
                    String s;
                    int i;
                    if (f.isDirectory()) {
                        return true;
                    }
                    if (f.isFile() && (i = (s = f.getName()).lastIndexOf(46)) > 0 && i < s.length() - 1) {
                        String ext = s.substring(i + 1).toLowerCase();
                        return ext.equals("xml");
                    }
                    return false;
                }
            });
            int returnVal = fileChooser.showOpenDialog(null);
            if (returnVal == 0) {
                file = fileChooser.getSelectedFile();
            }
        } else {
            String filename;
            FileDialog fd = new FileDialog((Frame)null, "Open", 0);
            fd.setDirectory(new File(lastDatasetPath).getParent());
            fd.setFile(new File(lastDatasetPath).getName());
            final AtomicBoolean workedWithFilenameFilter = new AtomicBoolean(false);
            fd.setFilenameFilter(new FilenameFilter(){
                private boolean firstTime = true;

                @Override
                public boolean accept(File dir, String name) {
                    int i;
                    if (this.firstTime) {
                        workedWithFilenameFilter.set(true);
                        this.firstTime = false;
                    }
                    if ((i = name.lastIndexOf(46)) > 0 && i < name.length() - 1) {
                        String ext = name.substring(i + 1).toLowerCase();
                        return ext.equals("xml");
                    }
                    return false;
                }
            });
            fd.setVisible(true);
            if (this.isMac() && !workedWithFilenameFilter.get()) {
                fd.setFilenameFilter(null);
                fd.setVisible(true);
            }
            if ((filename = fd.getFile()) != null) {
                file = new File(fd.getDirectory() + filename);
            }
        }
        if (file != null) {
            try {
                lastDatasetPath = file.getAbsolutePath();
                BigDataViewer.open((String)file.getAbsolutePath(), (String)file.getName(), (ProgressWriter)new ProgressWriterIJ(), (ViewerOptions)ViewerOptions.options());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isMac() {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        return OS.indexOf("mac") >= 0 || OS.indexOf("darwin") >= 0;
    }
}

